 clear all; clc;

%% confronto con centrato, radiale 0.05 assiale 0.01 (@1000 rpm)
open('piattoB_1000_c_bis.fig');
a = get(gca,'Children');
x2 = get(a, 'XData');
y2 = get(a, 'YData');
close();
%
M = importdata("radiale005assiale001.data");
x1 = M.data(:,1)*1000*(2*pi/60)*180/pi;
y1 = M.data(:, 2);
%
open('1000rpm_centrato.fig');
a = get(gca,'Children');
x3 = get(a, 'XData');
y3 = get(a, 'YData');
close();
%
figure(1000)
% 
% Plot dei dati estratti dai due files ".fig" in un unico grafico 
% 
for ii =  1:size(x2, 1)
    plot(x2{ii,:},y2{ii,:}*1e-5, ':k', 'linewidth', 2)
    hold on
end

plot(x1 - 92, y1,'-r', x3-80, y3, '-k')
grid on
xlim([0, 360])
xlabel('Angular position [deg]')
ylabel('Pressure [bar]')
title('PLATE B - 47 bar, 1000 RPM')
xlim([0, 360])


 %% LC = 0.025 mm   (@1000 rpm)
open('assiale0025.fig');
a = get(gca,'Children');
x2 = get(a, 'XData');
y2 = get(a, 'YData');
close();
%
M = importdata("assiale0025.data");
x1 = M.data(:,1)*1000*(2*pi/60)*180/pi;
y1 = M.data(:, 2);

figure(1000)
% 
% Plot dei dati estratti dai due files ".fig" in un unico grafico 
% 
for ii =  1:size(x2, 1)
    plot(x2{ii,:},y2{ii,:}*1e-5, ':k', 'linewidth', 2)
    hold on
end
plot(x1 - 92, y1,'-r')
grid on
xlim([0, 360])
xlabel('Angular position [deg]')
ylabel('Pressure [bar]')
title('AXIAL CLEARANCE: 0.025 mm (PLATE B - 47 bar, 1000 RPM)')
xlim([0, 360])

 %% LC = 0.04 mm   (@1000 rpm)
open('assiale004.fig');
a = get(gca,'Children');
x2 = get(a, 'XData');
y2 = get(a, 'YData');
close();
%
M = importdata("assiale004.data");
x1 = M.data(:,1)*1000*(2*pi/60)*180/pi;
y1 = M.data(:, 2);

figure(2000)
% 
% Plot dei dati estratti dai due files ".fig" in un unico grafico 
% 
for ii =  1:size(x2, 1)
    plot(x2{ii,:},y2{ii,:}*1e-5, ':k', 'linewidth', 2)
    hold on
end
plot(x1 - 92, y1,'-r')
grid on
xlim([0, 360])
xlabel('Angular position [deg]')
ylabel('Pressure [bar]')
title('AXIAL CLEARANCE: 0.04 mm (PLATE B - 47 bar, 1000 RPM)')
xlim([0, 360])

 %% LC = 0.05 mm   (@1000 rpm)
open('assiale005.fig');
a = get(gca,'Children');
x2 = get(a, 'XData');
y2 = get(a, 'YData');
close();
%
M = importdata("assiale005.data");
x1 = M.data(:,1)*1000*(2*pi/60)*180/pi;
y1 = M.data(:, 2);

figure(3000)
% 
% Plot dei dati estratti dai due files ".fig" in un unico grafico 
% 
for ii =  1:size(x2, 1)
    plot(x2{ii,:},y2{ii,:}*1e-5, ':k', 'linewidth', 2)
    hold on
end
plot(x1 - 92, y1,'-r')
grid on
xlim([0, 360])
xlabel('Angular position [deg]')
ylabel('Pressure [bar]')
title('AXIAL CLEARANCE: 0.05 mm (PLATE B - 47 bar, 1000 RPM)')
xlim([0, 360])

 %% LC = 0.075 mm   (@1000 rpm)
open('assiale0075.fig');
a = get(gca,'Children');
x2 = get(a, 'XData');
y2 = get(a, 'YData');
close();
%
M = importdata("assiale0075.data");
x1 = M.data(:,1)*1000*(2*pi/60)*180/pi;
y1 = M.data(:, 2);

figure(4000)
% 
% Plot dei dati estratti dai due files ".fig" in un unico grafico 
% 
for ii =  1:size(x2, 1)
    plot(x2{ii,:},y2{ii,:}*1e-5, ':k', 'linewidth', 2)
    hold on
end
plot(x1 - 92, y1,'-r')
grid on
xlim([0, 360])
xlabel('Angular position [deg]')
ylabel('Pressure [bar]')
title('AXIAL CLEARANCE: 0.075 mm (PLATE B - 47 bar, 1000 RPM)')
xlim([0, 360])

 %% 
 %% LC = 0.10 mm   (@1000 rpm)
open('assiale010.fig');
a = get(gca,'Children');
x2 = get(a, 'XData');
y2 = get(a, 'YData');
close();
%
M = importdata("assiale010.data");
x1 = M.data(:,1)*1000*(2*pi/60)*180/pi;
y1 = M.data(:, 2);

figure(5000)
% 
% Plot dei dati estratti dai due files ".fig" in un unico grafico 
% 
for ii =  1:size(x2, 1)
    plot(x2{ii,:},y2{ii,:}*1e-5, ':k', 'linewidth', 2)
    hold on
end
plot(x1 - 92, y1,'-r')
grid on
xlim([0, 360])
xlabel('Angular position [deg]')
ylabel('Pressure [bar]')
title('AXIAL CLEARANCE: 0.10 mm (PLATE B - 47 bar, 1000 RPM)')
xlim([0, 360])

